<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class AddressBook extends CI_Controller {

	function __construct() {
		parent::__construct();
		session_set_cookie_params(0,'/addressbook',DIRECT_DOMAIN,TRUE,TRUE);
		session_start();
		date_default_timezone_set(ENVIRONMENT_TIMEZONE);
		$this->load->library("encrypt");
		$this->load->library("form_validation");
		$this->form_validation->set_error_delimiters('', '');
		$this->load->helper("url");
		$this->load->library("ldap");
		$this->load->model('private_distribution_list_model','pdistlist');
		
		//if user is not authenticated, redirect to auth page, otherwise proceed to load controller
		if($this->session->userdata("is_loggedin") != "true") { $this->session->sess_destroy(); session_destroy(); redirect("auth/logout"); }
		
		//prev last activity update set to current last activity so we can reset it for functions we don't want to consider "activity"
		if(strlen($this->session->userdata('app_last_activity')) > 0) { $this->session->set_userdata('prev_last_activity',$this->session->userdata('app_last_activity')); }
		//if last activity not yet set, set it to current time
		else { $this->session->set_userdata('app_last_activity',time()); }
		
        //check if it the user needs to be logged out due to inactivity
        if(abs($this->session->userdata('app_last_activity') - time()) > (SESSION_TIMEOUT_MINS*60)) { $this->session->sess_destroy(); session_destroy(); redirect("auth"); }    
        //update the last activity for the timeout
		else { $this->session->set_userdata('app_last_activity',time()); }

		//check if user has been removed since last page load
		$this->load->database();
		$user_exists = $this->db->query("SELECT user_name FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
		//only destroy session if query successfully shows that the user no longer exists among active users
		if($user_exists) { if($user_exists->num_rows() < 1 || $user_exists->num_rows() > 1) { $this->session->sess_destroy(); session_destroy(); redirect("auth"); } }
	}
	
	public function index()
	{
		$data["title"] = PORTAL_TITLE_PREFIX . "Address Book";
		$data["initial_json"] = $this->ajax_search(NULL,NULL,FALSE);
		$this->load->view("addressbook/index",$data);
	}
	
	public function contacts() {
		$data["title"] = PORTAL_TITLE_PREFIX . "Contacts List";
		$data["initial_json"] = $this->ajax_contact_search(NULL,NULL,FALSE);
		$this->load->view("addressbook/contacts",$data);
	}
	
	public function add_contact() {
		$this->form_validation->set_rules("first_name","First Name","required","xss_clean");
		$this->form_validation->set_rules("last_name","Last Name","required","xss_clean");
		$this->form_validation->set_rules("mail","Direct Address","required|valid_email|callback_valid_trusted_address|","xss_clean");
		if($this->form_validation->run() === TRUE) {
			$this->load->database();
			$first = $this->input->post("first_name",TRUE);
			$last = $this->input->post("last_name",TRUE);
			$mail = $this->input->post("mail",TRUE);
			$middle = $this->input->post("middle_name",TRUE);
			$telephone = $this->input->post("telephone",TRUE);
			$title = $this->input->post("title",TRUE);
			$department = $this->input->post("department",TRUE);
			$organization = $this->input->post("organization",TRUE);
			$get_user_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
			
			if($get_user_id && $get_user_id->num_rows() == 1) {
				$data["title"] = PORTAL_TITLE_PREFIX . "Add Contact";
				
				$row = $get_user_id->row_array();
				$user_id = $row["user_id"];
				$this->db->query("INSERT INTO contacts (user_id,first_name,middle_name,last_name,organization,department,telephone,mail,title) VALUES (" . $this->db->escape($user_id) . "," . $this->db->escape($first) . "," . $this->db->escape($middle) . "," . $this->db->escape($last) . "," . $this->db->escape($organization) . "," . $this->db->escape($department) . "," . $this->db->escape($telephone) . "," . $this->db->escape($mail) . "," . $this->db->escape($title) . ")");
				$this->load->view("addressbook/contacts",$data);
			}
		}
		else {
			$data["title"] = PORTAL_TITLE_PREFIX . "Add Contact";
			$form_data = $this->input->post(NULL);
			$data['form_data'] = $form_data;
			$validation_errors = array();
			if(is_array($form_data)) {
				foreach($form_data as $key => $input) {
					if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
				}
				$data['validation_errors'] = $validation_errors;
			}
			$this->load->view("addressbook/add_contact",$data);
		}
	}
	
	
	public function edit_contact($contact_id) {
		$id = $this->input->post("id",TRUE);
		$value = $this->input->post("value",TRUE);
		
		$this->load->database();
		switch($id) {
			case "first_name": $field = "first_name"; break;
			case "last_name": $field = "last_name"; break;
			case "middle_name": $field = "middle_name"; break;
			case "mail": $field = "mail"; break;
			case "telephone": $field = "telephone"; break;
			case "title": $field = "title"; break;
			case "organization": $field = "organization"; break;
			case "department": $field = "department"; break;
		}
		
		$update = $this->db->query("UPDATE contacts SET " . $field . "=" . $this->db->escape($value) . " WHERE contact_id = " . $this->db->escape($contact_id));
		
		if($update) { echo htmlentities($value); }
	}
	public function delete_contact($contact_id) {
		$this->load->database();
		$get_user_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
		if($get_user_id && $get_user_id->num_rows() == 1) {
			$row = $get_user_id->row_array();
			$user_id = $row["user_id"];
			//delete only if logged in user and contact_id matches contacts record
			$this->db->query("DELETE FROM contacts WHERE contact_id=". $this->db->escape($contact_id) . " AND user_id=" . $this->db->escape($user_id));
		}
	}
	
	public function add_distribution_list() {
		$this->load->view('addressbook/add_distribution_list');
	}
	
	
	public function get_distribution_list_view($id) {
		$data['id'] = $id;
		$this->load->view('distribution_list/edit_list');
		//$this->view->load('addressbook/edit_distribution_list',$data);
	}
	
	public function ajax_contact_search($input = NULL,$sizelimit = NULL, $echo = TRUE) {
		$this->load->database();
		$this->load->model('distribution_list_model','distlist');
		$input = rawurldecode($input);
		if(is_null($input)) { $input = ""; }
		
		//get contacts and load into results array
		if(!is_null($sizelimit)) { $contacts = $this->db->query("SELECT TOP(" .$sizelimit . ") * FROM contacts WHERE (last_name LIKE (" . $this->db->escape($input) . "+ '%') OR mail LIKE (" . $this->db->escape($input) . "+ '%')) AND user_id = (SELECT user_id FROM users WHERE  user_deleted_flag=0 AND user_name = " . $this->db->escape($this->session->userdata("username")) . ")"); }
		else { $contacts = $this->db->query("SELECT * FROM contacts WHERE (last_name LIKE (" . $this->db->escape($input) . "+ '%') OR mail LIKE (" . $this->db->escape($input) . "+ '%')) AND user_id = (SELECT user_id FROM users WHERE  user_deleted_flag=0 AND user_name = " . $this->db->escape($this->session->userdata("username")) . ")"); }
		$result_arr = array();
		for($i = 0; $i < $contacts->num_rows(); $i++) {
			$row = $contacts->row_array($i);
			$displayname = $row["last_name"] . ", " . $row["first_name"];
			if(isset($row["middle_name"]) && (strlen($row["middle_name"]) > 0)) { $displayname .= " " . $row["middle_name"]; }
			$contact_arr = array('type'=>'contact',"cid" => $row["contact_id"], "displayname" => $displayname, "mail" => $row["mail"], "givenname" => $row["first_name"], "sn" => $row["last_name"], "initials" => $row["middle_name"], "o" => $row["organization"], "departmentnumber" => $row["department"], "telephonenumber" => $row["telephone"], "title" => $row["title"]);
			//don't return blank/null attributes
			foreach($contact_arr as $attr => $val) {
				if(!isset($val) || strlen($val) <= 0) {
					unset($contact_arr[$attr]);
				}
			}
			array_push($result_arr,$contact_arr);
		}
		
		//get private distribution lists and load into results array
		$this->db->order_by('name');
		$this->db->like('name',$input,'after');
		$dist_list_result = $this->pdistlist->find(array());
		for($i = 0; $i < count($dist_list_result); $i++) {
			$row = $dist_list_result[$i];
			$list_arr = array('type'=>'list','id'=>$row['id'],'displayname'=>$row['name'],'alias'=>$this->pdistlist->alias($row['id']),'description'=>$row['description'],'id'=>$row['id'],'addresses'=>$row['addresses']);
			
			if(!empty($list_arr['addresses'])){
				$address_tokens = array();
				$address_array = preg_split("/;/", $list_arr['addresses'], null, PREG_SPLIT_NO_EMPTY);
				$display_names_array = $this->distlist->display_names_for_direct_addresses($address_array);
				foreach($address_array as $address) {
					if(!isset($display_names_array[$address])) {
						$display_names_array[$address] = trim($address);
					}
				}
				foreach($display_names_array as $address => $display_name) {
					array_push($address_tokens,$display_name . ' (' . trim($address) . ')');
				}
				$display_names = implode('; ', $display_names_array);
				$addresses_in_display_order = implode('; ', array_keys($display_names_array));
				$list_arr['display_names'] = $display_names;
				$list_arr['addresses_in_display_order'] = $addresses_in_display_order;
				$list_arr['address_tokens'] = json_encode($address_tokens);
			}
			
			//don't return blank/null attributes
			foreach($list_arr as $attr => $val) {
				if(!isset($val) || strlen($val) <= 0) {
					unset($list_arr[$attr]);
				}
			}
			array_push($result_arr,$list_arr);
		}
		
		//sort result array (natural order, case insensitive)
		usort($result_arr, function( $el1, $el2) { return strnatcasecmp( $el1['displayname'], $el2['displayname']); });
		
		array_walk_recursive($result_arr, function (&$value) {
			$value = htmlentities($value);
		});
		//only echo if the request comes from AJAX
		if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) &&  $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest') {
			if($echo) { echo json_encode($result_arr); }
		}
		//if not echoing, allow return of JSON data
		if(!$echo) { return json_encode($result_arr); }
	}
	
	public function ajax_search($input = NULL,$sizelimit = NULL, $echo = TRUE) {
		if(!is_null($sizelimit)) { $properties = NULL; }
		else {  $properties = array('displayname','objectclass','mail','uid','givenname','initials','sn','physicaldeliveryofficename','o','departmentnumber','mobile','telephonenumber','title');}
		//get people
		$person_result = $this->ldap->search(rawurldecode($input),$sizelimit,$properties);
		array_walk_recursive($person_result, function (&$value) {
			$value = htmlentities($value);
		});
		
		//get distribution lists
		$this->load->model('distribution_list_model','distlist');
		$this->load->model('public_distribution_list_model','pubdistlist');
		$list_result = $this->pubdistlist->find(array('cn'=>$input.'*'));
		$add_list = array();
		foreach($list_result as $index => $entry) {
			if(!empty($list_result[$index]['addresses'])){
				$address_tokens = array();
				$address_array = preg_split("/;/", $list_result[$index]['addresses'], null, PREG_SPLIT_NO_EMPTY);
				$display_names_array = $this->distlist->display_names_for_direct_addresses($address_array);
				foreach($address_array as $address) {
					if(!isset($display_names_array[$address])) {
						$display_names_array[$address] = trim($address);
					}
				}
				foreach($display_names_array as $address => $display_name) {
					array_push($address_tokens,$display_name . ' (' . trim($address) . ')');
				}
				$display_names = implode('; ', $display_names_array);
				$addresses_in_display_order = implode('; ', array_keys($display_names_array));
				$list_result[$index]['display_names'] = $display_names;
				$list_result[$index]['addresses_in_display_order'] = $addresses_in_display_order;
				$list_result[$index]['address_tokens'] = json_encode($address_tokens);
				$list_result[$index]['alias'] = $this->pubdistlist->alias($entry['id']);
				array_push($add_list , $list_result[$index]);
			}
		}
		array_walk_recursive($add_list, function (&$value) {
			$value = htmlentities($value);
		});
		
		
			
		//create and sort combined result array (natural order, case insensitive)
		$result = array_merge($person_result,$add_list);
		usort($result, function($el1, $el2) { return strnatcasecmp( (isset($el1['displayname']) ? $el1['displayname'] : $el1['name']), (isset($el2['displayname']) ? $el2['displayname'] : $el2['name'])); });
		
		//only echo if the request comes from AJAX
		if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) &&  $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest') {
			if($echo) { echo json_encode($result); }
		}
		//if not echoing, allow return of JSON data
		if(!$echo) { return json_encode($result); }
	}
	
	public function valid_trusted_address($str) {
		//have to urlencode / base64 encode the address to send to the web service
		$str = rawurlencode(base64_encode($str));
		$resource = '/direct/validate/address/'.$str.'/format/json';
		$url = WEBSERVICE_URL . $resource;
		
		$headers = array(
			'Authorization: DPII ' . WEBSERVICE_PUBLIC_KEY . ':'. base64_encode(hash_hmac('sha256',"GET\n" . date('U'). "\n" . $resource, WEBSERVICE_PRIVATE_KEY)),
			'Date: ' . date('U'),
			);
		$ch = curl_init();
		curl_setopt($ch,CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER,$headers);
		$server_output = curl_exec($ch);
		$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$response = json_decode($server_output);
		if(isset($response->valid)) {
			$valid = $response->valid;
			if(!$valid) { $this->form_validation->set_message('valid_trusted_address', 'The %s field must be a trusted Direct Address'); }
			return $valid;
		}
		else { $this->form_validation->set_message('valid_trusted_address', 'The %s field must be a trusted Direct Address'); return FALSE; }
	}
}
